const handleMessage = (() => {
    const errorToastBody = document.getElementById('errorToastBody');
    const errorToastContent = document.getElementById('errorToastContent');
    const errorCloseBtn = document.getElementById('errorCloseBtn');

    const errorCloseHandler = () => {
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.CLOSE_NOTIFICATION,
            type: CONSTANTS.NOTIFICATION_TYPES.ERROR
        });
    };

    const updateHeight = () => {
        const overflowBefore = document.body.style.overflow;
        document.body.style.overflow = CONSTANTS.VISIBILITY.HIDDEN;
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.SYNC_NOTIFICATION_SIZE,
            type: CONSTANTS.NOTIFICATION_TYPES.ERROR,
            width: errorToastBody.scrollWidth,
            height: errorToastBody.scrollHeight
        });
        document.body.style.overflow = overflowBefore;
    };

    return event => {
        if (!event.data.sender || event.data.sender !== CONSTANTS.MESSAGE_SENDERS.S7_NOTIFICATION) {
            return;
        }

        if (event.data.type !== CONSTANTS.NOTIFICATION_TYPES.ERROR) {
            return;
        }

        errorToastContent.innerText = event.data.message;

        errorCloseBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, errorCloseHandler);

        updateHeight();
    }
})();

window.addEventListener(CONSTANTS.EVENTS.WINDOW.MESSAGE, handleMessage);
